$(document).ready(function() {

   var iframe = $("<iframe id='metastore-tools-popup'> </iframe>");

   $(iframe).css({"border"  : "0",
                  "padding" : "0",
                  "margin"  : "0"
   });

   /*
    * @param  event object
    */
   function metastoreToolsPopup(evt) {

       var $this = $(this),
           type = $this.attr("resourcetype"),
           urlcontext = $this.attr("urlcontext"),
           context = $this.attr("resourcecontext"),
           url = $this.attr("itemurl"),
           redirectTo = $this.attr("redirectto"),
           title = $this.attr("title"),
           action = $this.attr("resourceaction"),
           DIALOG_WIDTH = 960,
           DIALOG_HEIGHT = 490,
           MAGIC_WIDTH = "935px",
           MSG1 = "Please wait until all uploads have completed before submitting the form.",
           MSG2 = "Are you sure you want to close this window? Any changes will be lost.";

       // Stop the page from jumping to the top...
       evt.preventDefault();

       if (urlcontext !== "") {
           url = urlcontext + url;
           redirectTo = urlcontext + redirectTo;
       }

       url = url.split("?")[0].split(";")[0];

       if (action.toUpperCase() === "CREATE") {
           url += "/create";
       }
       if (action.toUpperCase() === "EDIT") {
           url += "/edit";
       }
       if (action.toUpperCase() === "DELETE") {
           url += "/delete";
       }

       url += "?&popup=true&portal=admin&context=" + context;

       if (action.toUpperCase() === "CREATE") {
           url += "&type=" + type;
       }
       if (redirectTo) {
           url += "&redirectTo=" + redirectTo;
       }

       $("body").append(iframe);
       iframe.get(0).src = url;

       var iframeButtons = {
               Cancel: function() {
                   $(this).dialog("close");
               }
       };

       iframeButtons[action] = function() {
           var iframeContent = $("#metastore-tools-popup").get(0).contentWindow;
           if (iframeContent.UPLOADS_IN_PROGRESS > 0) {
               alert(MSG1);
               return;
           }
           iframeContent.$(".facet-form,.delete-form").submit();
           return false;
       };
       iframe.dialog({
           bgiframe: true,
           height: DIALOG_HEIGHT,
           width: DIALOG_WIDTH,
           modal: true,
           title: title,
           buttons: iframeButtons,
           beforeclose: function() {
               return confirm(MSG2);
           },
           close: function() {
               this.src = "about:blank";
               $(this).remove();
           }
       });
       iframe.css({"width": MAGIC_WIDTH});
   }

   $(".metastore-tools-trigger").on("click", metastoreToolsPopup);

   $(".js-ft-sd-hook").on("click", ".metastore-tools-trigger", metastoreToolsPopup);

});
